VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Object = "{3B7C8863-D78F-101B-B9B5-04021C009402}#1.2#0"; "RICHTX32.OCX"
Begin VB.MDIForm frmMain 
   BackColor       =   &H8000000C&
   Caption         =   "Renamer"
   ClientHeight    =   5865
   ClientLeft      =   465
   ClientTop       =   825
   ClientWidth     =   8325
   Icon            =   "frmMain.frx":0000
   LinkTopic       =   "MDIForm1"
   Begin VB.PictureBox Picture1 
      Align           =   2  'Align Bottom
      Height          =   1335
      Left            =   0
      ScaleHeight     =   1275
      ScaleWidth      =   8265
      TabIndex        =   2
      Top             =   4260
      Width           =   8325
      Begin RichTextLib.RichTextBox rtbHistory 
         Height          =   1095
         Left            =   360
         TabIndex        =   3
         TabStop         =   0   'False
         Top             =   0
         Width           =   7335
         _ExtentX        =   12938
         _ExtentY        =   1931
         _Version        =   393217
         Enabled         =   -1  'True
         ReadOnly        =   -1  'True
         ScrollBars      =   3
         TextRTF         =   $"frmMain.frx":0442
      End
   End
   Begin MSComctlLib.StatusBar sbStatusBar 
      Align           =   2  'Align Bottom
      Height          =   270
      Left            =   0
      TabIndex        =   0
      Top             =   5595
      Width           =   8325
      _ExtentX        =   14684
      _ExtentY        =   476
      _Version        =   393216
      BeginProperty Panels {8E3867A5-8586-11D1-B16A-00C0F0283628} 
         NumPanels       =   3
         BeginProperty Panel1 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            AutoSize        =   2
            Object.Width           =   7620
            MinWidth        =   7620
            Text            =   "Ready"
            TextSave        =   "Ready"
         EndProperty
         BeginProperty Panel2 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            Style           =   6
            AutoSize        =   2
            TextSave        =   "5/9/2003"
         EndProperty
         BeginProperty Panel3 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            Style           =   5
            AutoSize        =   2
            TextSave        =   "5:26 PM"
         EndProperty
      EndProperty
   End
   Begin MSComctlLib.ImageList imlToolbarIcons 
      Left            =   3000
      Top             =   1800
      _ExtentX        =   1005
      _ExtentY        =   1005
      BackColor       =   -2147483643
      ImageWidth      =   16
      ImageHeight     =   16
      MaskColor       =   12632256
      _Version        =   393216
      BeginProperty Images {2C247F25-8591-11D1-B16A-00C0F0283628} 
         NumListImages   =   9
         BeginProperty ListImage1 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmMain.frx":050B
            Key             =   "New"
         EndProperty
         BeginProperty ListImage2 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmMain.frx":061D
            Key             =   "Open"
         EndProperty
         BeginProperty ListImage3 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmMain.frx":072F
            Key             =   "Save"
         EndProperty
         BeginProperty ListImage4 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmMain.frx":0841
            Key             =   "Map Network Drive"
         EndProperty
         BeginProperty ListImage5 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmMain.frx":0953
            Key             =   "Help"
         EndProperty
         BeginProperty ListImage6 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmMain.frx":0A65
            Key             =   ""
         EndProperty
         BeginProperty ListImage7 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmMain.frx":0B79
            Key             =   ""
         EndProperty
         BeginProperty ListImage8 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmMain.frx":0C8D
            Key             =   ""
         EndProperty
         BeginProperty ListImage9 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmMain.frx":0DA1
            Key             =   ""
         EndProperty
      EndProperty
   End
   Begin MSComctlLib.Toolbar tbToolBar 
      Align           =   1  'Align Top
      Height          =   420
      Left            =   0
      TabIndex        =   1
      Top             =   0
      Width           =   8325
      _ExtentX        =   14684
      _ExtentY        =   741
      ButtonWidth     =   609
      ButtonHeight    =   582
      Appearance      =   1
      ImageList       =   "imlToolbarIcons"
      _Version        =   393216
      BeginProperty Buttons {66833FE8-8583-11D1-B16A-00C0F0283628} 
         NumButtons      =   6
         BeginProperty Button1 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Key             =   "New"
            Object.ToolTipText     =   "New"
            ImageIndex      =   1
         EndProperty
         BeginProperty Button2 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Key             =   "Open"
            Object.ToolTipText     =   "Open"
            ImageIndex      =   2
         EndProperty
         BeginProperty Button3 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Key             =   "Save"
            Object.ToolTipText     =   "Save"
            ImageIndex      =   3
         EndProperty
         BeginProperty Button4 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Style           =   3
         EndProperty
         BeginProperty Button5 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Key             =   "Map Network Drive"
            Object.ToolTipText     =   "Map Network Drive"
            ImageIndex      =   4
         EndProperty
         BeginProperty Button6 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Key             =   "Help"
            Object.ToolTipText     =   "Help"
            ImageIndex      =   5
         EndProperty
      EndProperty
   End
   Begin VB.Menu mnuFile 
      Caption         =   "File"
      Begin VB.Menu mnuFileNew 
         Caption         =   "New"
         Shortcut        =   ^N
      End
      Begin VB.Menu mnuFileOpen 
         Caption         =   "Open"
         Shortcut        =   ^O
      End
      Begin VB.Menu mnuFileClose 
         Caption         =   "Close"
      End
      Begin VB.Menu mnuFileBar0 
         Caption         =   "-"
      End
      Begin VB.Menu mnuFileSave 
         Caption         =   "Save"
      End
      Begin VB.Menu mnuFileSaveAs 
         Caption         =   "Save As..."
      End
      Begin VB.Menu mnuSaveLog 
         Caption         =   "Save Log File As..."
      End
      Begin VB.Menu mnuFileBar3 
         Caption         =   "-"
      End
      Begin VB.Menu mnuMapNetwork 
         Caption         =   "Map Network Drive..."
      End
      Begin VB.Menu mnuFileBar4 
         Caption         =   "-"
      End
      Begin VB.Menu mnuFileExit 
         Caption         =   "Exit"
      End
   End
   Begin VB.Menu mnuView 
      Caption         =   "View"
      Begin VB.Menu mnuViewToolbar 
         Caption         =   "Toolbar"
         Checked         =   -1  'True
      End
      Begin VB.Menu mnuViewStatusBar 
         Caption         =   "Status Bar"
         Checked         =   -1  'True
      End
   End
   Begin VB.Menu mnuWindow 
      Caption         =   "Window"
      WindowList      =   -1  'True
      Begin VB.Menu mnuWindowNewWindow 
         Caption         =   "New Window"
      End
      Begin VB.Menu mnuWindowBar0 
         Caption         =   "-"
      End
      Begin VB.Menu mnuWindowCascade 
         Caption         =   "Cascade"
      End
      Begin VB.Menu mnuWindowTileHorizontal 
         Caption         =   "Tile Horizontal"
      End
      Begin VB.Menu mnuWindowTileVertical 
         Caption         =   "Tile Vertical"
      End
      Begin VB.Menu mnuWindowArrangeIcons 
         Caption         =   "Arrange Icons"
      End
   End
   Begin VB.Menu mnuHelp 
      Caption         =   "Help"
      Begin VB.Menu mnuHelpContents 
         Caption         =   "Contents"
      End
      Begin VB.Menu mnuHelpSearchForHelpOn 
         Caption         =   "Search For Help On..."
      End
      Begin VB.Menu mnuHelpBar0 
         Caption         =   "-"
      End
      Begin VB.Menu mnuHelpAbout 
         Caption         =   "About Renamer"
      End
   End
   Begin VB.Menu mnuPopup 
      Caption         =   "mnuPopUp"
      Visible         =   0   'False
      Begin VB.Menu mnuOpen 
         Caption         =   "Open"
      End
      Begin VB.Menu mnuAbout 
         Caption         =   "About Renamer"
      End
      Begin VB.Menu mnuPopupBar0 
         Caption         =   "-"
      End
      Begin VB.Menu mnuPopupExit 
         Caption         =   "Exit Renamer"
      End
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'WinHelp API
Private Declare Function OSWinHelp% Lib "user32" Alias "WinHelpA" (ByVal hwnd&, ByVal HelpFile$, ByVal wCommand%, dwData As Any)
'APIs for retrieving data from .ini files (or in this case .rnm files)
Private Declare Function GetPrivateProfileInt Lib "kernel32" Alias "GetPrivateProfileIntA" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal nDefault As Long, ByVal lpFileName As String) As Long
Private Declare Function GetPrivateProfileString Lib "kernel32" Alias "GetPrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Long, ByVal lpFileName As String) As Long

Dim lDocumentCount As Long          'to store number of open child windows
Dim AutoActivateForms() As Integer  'Array to store how many windows were activated

'On loading main MDI form
Private Sub MDIForm_Load()

    On Error GoTo Error_Handler     'trap errors

    'Update log
    updateLog ICO_INFO, " " & Now & " : Renamer program started"
    
    lDocumentCount = 0          'Initialize document count variable
    
    'System tray settings
    nid.cbSize = Len(nid)
    nid.hwnd = Picture1.hwnd
    nid.uID = 1&
    nid.uFlags = NIF_ICON Or NIF_TIP Or NIF_MESSAGE
    nid.uCallbackMessage = WM_MOUSEMOVE
    nid.hIcon = Me.Icon
    ' Chr$(0) is required at the end of the string
    nid.szTip = "Renamer" + vbNullChar
    Shell_NotifyIcon NIM_ADD, nid

    'Retrieve settings from registry (position on screen and size)
    MLeft = GetSetting(App.Title, "Settings", "MainLeft", 1000)
    MTop = GetSetting(App.Title, "Settings", "MainTop", 1000)
    MWidth = GetSetting(App.Title, "Settings", "MainWidth", 8000)
    MHeight = GetSetting(App.Title, "Settings", "MainHeight", 6500)
    
    'Set dimensions of main form
    Me.Left = MLeft
    Me.Top = MTop
    Me.Width = MWidth
    Me.Height = MHeight
         
    ReDim AutoActivateForms(1) 'reset array size ready for first window

    'Renamer can be started from the command line with a .rnm file passed to it
    'If a command line argument was passed to it open that file, otherwise load defaults
    If Len(Command$) Then MyFile$ = Command$
    getprofilesettings (MyFile$)

    'If any of windows in loaded settings file were activated, reactivate them now
    VisibleForms% = Forms.Count
    For x% = 2 To VisibleForms%
        If AutoActivateForms(x% - 1) = 1 Then
            Forms(x% - 1).cmdActivate_Click
        End If
    Next
    
    IsDirty = False
    
Exit_Normal:
    Exit Sub

Error_Handler:
    'On error display message box, then exit this routine
    'MsgBox "Error loading Program: " & Err.Number & " : " & Err.Description, vbCritical, "Renamer"
    'Update log
    updateLog ICO_ERR, " " & Now & " : Error loading Program: " & Err.Number & " : " & Err.Description
    Resume Exit_Normal
    
End Sub

'When closing program
Private Sub MDIForm_QueryUnload(Cancel As Integer, UnloadMode As Integer)
    writeprofilesettings ("")
    'close all child forms - this causes unload event of each form to fire
    'which prompts to save changes if changes have been made
    Do While Not (Me.ActiveForm Is Nothing)
        Unload Me.ActiveForm
    Loop
End Sub

'Loads a new Child Window
Private Sub LoadNewDoc()
    Dim frmD As frmDocument
    lDocumentCount = lDocumentCount + 1
    Set frmD = New frmDocument
    frmD.Caption = "File Renamer " & lDocumentCount
    frmD.Show
End Sub

'On Resize of program window
Private Sub MDIForm_Resize()
    'If minmized hide so that does not appear in taskbar
    'Will only be visible in the system tray
    If Me.WindowState = vbMinimized Then Me.Visible = False
    rtbHistory.Left = 0
    rtbHistory.Height = Picture1.Height - 75
    rtbHistory.Width = Me.Width - 200
End Sub

'When closing program
Private Sub MDIForm_Unload(Cancel As Integer)
    If Me.WindowState <> vbMinimized Then   'if not minimized
        'Save windows size and location in regsitry
        SaveSetting App.Title, "Settings", "MainLeft", Me.Left
        SaveSetting App.Title, "Settings", "MainTop", Me.Top
        SaveSetting App.Title, "Settings", "MainWidth", Me.Width
        SaveSetting App.Title, "Settings", "MainHeight", Me.Height
    End If
    'remove icon from system tray
    Shell_NotifyIcon NIM_DELETE, nid
End Sub

'Map Network Drive menu option
Private Sub mnuMapNetwork_Click()
    'Display Windows' standard Map Network Drive Dialog
    WNetConnectionDialog hwnd, 1
End Sub





'Right Click Menu for system tray icon (Exit)
Private Sub mnuPopupExit_Click()
    Unload Me
End Sub

Private Sub mnuSaveLog_Click()
    On Error GoTo Error_Handler     'trap errors

    Dim LFile As String

    'if no forms open then do nothing
    If ActiveForm Is Nothing Then GoTo Exit_Normal
    
    If Not cFile.VBGetSaveFileName(LFile, , True, "Log Files(*.Log)|*.Log", , , "Save Renamer Log File", "log", Me.hwnd) Then Exit Sub

    If LFile = vbNullString Then Exit Sub
    Forms(0).rtbHistory.SaveFile LFile, rtfText
    
Exit_Normal:
    Exit Sub

Error_Handler:
    'On error display message box, then exit this routine
    'MsgBox "Error Saving File: " & Err.Number & " : " & Err.Description, vbCritical, "Renamer"
    'Update log
    updateLog ICO_ERR, " " & Now & " : Error Saving Log File: " & Err.Number & " : " & Err.Description
    Resume Exit_Normal
    
End Sub

Private Sub Picture1_MouseMove(Button As Integer, Shift As Integer, x As Single, y As Single)
    If Me.WindowState <> vbMinimized Then Exit Sub
    ' uCallBackMessage specifies the message the system will send to your
    ' form for notifying mouse actions on the icon in the System Tray;
    ' the value of wParam associated to this message is the value of
    ' the original mouse message. You can subclass the form to trap this
    ' message and use wParam to determine which mouse action occurred,
    ' but there is a better way.
    
    ' The trick is to set the callback message equal to WM_MOUSEMOVE, which
    ' causes a Form_MouseMove event to be automatically raised in yout form.
    ' If the form's ScaleMode is set to vbPixels, the value of the X
    ' argument for this event is equal to the original value of the wParam
    ' argument of the callback message, and therefore you can use it to
    ' determine which mouse action was performed on the System Tray icon.
    ' If the ScaleMode is different from vbPixel you can use the following formula
    ' method to convert it:
    
On Error GoTo Error_Handler     'trap errors

    Dim Msg As Long
    Msg = x \ Screen.TwipsPerPixelX
'    Msg = (X * 96) \ 1440
    
    Select Case Msg
        Case WM_LBUTTONDBLCLK   'Left button double click
            'frmAbout.Show       'display about box
            Me.WindowState = vbNormal
            Me.Visible = True
            AppActivate Me.Caption
        Case WM_RBUTTONUP       'Right click
            Me.PopupMenu mnuPopup, , , , mnuAbout   'Display menu
    End Select

Exit_Normal:
    Exit Sub

Error_Handler:
    'On error display message box, then exit this routine
    'MsgBox "Mouse Move Error: " & Err.Number & " : " & Err.Description, vbCritical, "Renamer"
    'Update log
    updateLog ICO_ERR, " " & Now & " : Mouse Move Error: " & Err.Number & " : " & Err.Description
    Resume Exit_Normal
End Sub

'Tool Bar click
Private Sub tbToolBar_ButtonClick(ByVal Button As MSComctlLib.Button)
'    On Error Resume Next
    Select Case Button.Key
        Case "New"
            mnuWindowNewWindow_Click
        Case "Open"
            mnuFileOpen_Click
        Case "Save"
            mnuFileSave_Click
        Case "Map Network Drive"
            mnuMapNetwork_Click
        Case "Help"
            Dim nRet As Integer
            'display Help Contents
            nRet = OSWinHelp(Me.hwnd, App.HelpFile, 3, 0)
            If Err Then
                MsgBox Err.Description
            End If
    End Select
End Sub

'Help Menu: About
Private Sub mnuHelpAbout_Click()
    frmAbout.Show vbModal, Me   'Display About Form
End Sub

'Help Menu: Search For Help Menu
Private Sub mnuHelpSearchForHelpOn_Click()
    Dim nRet As Integer

    On Error Resume Next
    nRet = OSWinHelp(Me.hwnd, App.HelpFile, 261, 0)
    If Err Then
        MsgBox Err.Description
    End If
End Sub

'Help Menu: Display Help contents
Private Sub mnuHelpContents_Click()
    Dim nRet As Integer
        
    On Error Resume Next
    nRet = OSWinHelp(Me.hwnd, App.HelpFile, 3, 0)
    If Err Then
        MsgBox Err.Description
    End If
End Sub

'Window Menu: Arrange Icons
Private Sub mnuWindowArrangeIcons_Click()
    Me.Arrange vbArrangeIcons
End Sub

'Window Menu: Tile Vertical
Private Sub mnuWindowTileVertical_Click()
    Me.Arrange vbTileVertical
End Sub

'Window Menu: Tile Horizontal
Private Sub mnuWindowTileHorizontal_Click()
    Me.Arrange vbTileHorizontal
End Sub

'Window Menu: Cascade
Private Sub mnuWindowCascade_Click()
    Me.Arrange vbCascade
End Sub

'View Menu: Statusbar
Private Sub mnuViewStatusBar_Click()
    mnuViewStatusBar.Checked = Not mnuViewStatusBar.Checked
    sbStatusBar.Visible = mnuViewStatusBar.Checked
End Sub

'View Menu: Toolbar
Private Sub mnuViewToolbar_Click()
    mnuViewToolbar.Checked = Not mnuViewToolbar.Checked
    tbToolBar.Visible = mnuViewToolbar.Checked
End Sub

'File Menu: New
Private Sub mnuWindowNewWindow_Click()
    LoadNewDoc
End Sub

'File Menu: Exit
Private Sub mnuFileExit_Click()
    'unload this form
    Unload Me
End Sub

'File Menu: Save As...
Private Sub mnuFileSaveAs_Click()

    On Error GoTo Error_Handler     'trap errors

    'if no forms open then do nothing
    If ActiveForm Is Nothing Then GoTo Exit_Normal
    
    If Not cFile.VBGetSaveFileName(SFile, , True, "Settings (*.rnm)|*.rnm", , , "Save your settings", "Rnm", Me.hwnd) Then Exit Sub

    If SFile = vbNullString Then Exit Sub
    tFile = Mid(SFile, InStrRev(SFile, "\") + 1, Len(SFile) - InStrRev(SFile, "\"))
    
    'Set Application's caption to reflect Saved FileName
    Me.Caption = "Renamer - " & tFile
    writeprofilesettings (SFile)    'Save Settings to file with chosen Filename
    IsDirty = False                 'Reset isDirty flag
    
Exit_Normal:
    Exit Sub

Error_Handler:
    'On error display message box, then exit this routine
    'MsgBox "Error Saving File: " & Err.Number & " : " & Err.Description, vbCritical, "Renamer"
    'Update log
    updateLog ICO_ERR, " " & Now & " : Error Saving File: " & Err.Number & " : " & Err.Description
    Resume Exit_Normal
End Sub

'File Menu: Save
Private Sub mnuFileSave_Click()
    
    On Error GoTo Error_Handler     'trap errors
    
    'If file is saved the caption will be "Renamer - Filename.rnm"
    ' Otherwise will be just "Renamer" so check for "-" character
    ' If not found or our Global SFile variable which stores
    ' the opened/saved filename and path is empty then display Save As... Dialog
    If InStr(1, Me.Caption, "-") = 0 Or SFile = "" Then
        mnuFileSaveAs_Click
    Else
        'SFile = Right(Me.Caption, Len(Me.Caption) - 10)
        writeprofilesettings (SFile)
    End If
    IsDirty = False
    
Exit_Normal:
    Exit Sub

Error_Handler:
    'On error display message box, then exit this routine
    'MsgBox "Error Saving File: " & Err.Number & " : " & Err.Description, vbCritical, "Renamer"
        'Update log
    updateLog ICO_ERR, " " & Now & " : Error Saving File: " & Err.Number & " : " & Err.Description
    Resume Exit_Normal
End Sub

'File Menu: Close
Private Sub mnuFileClose_Click()
    'If child windows open then
    If Not (Me.ActiveForm Is Nothing) Then
        Unload ActiveForm       'close active child window
        Me.Caption = "Renamer"  'reset main caption to Renamer
    End If
End Sub

'File Menu: Open
Private Sub mnuFileOpen_Click()
    Dim tFile As String
    
    'reset doc count so that subsequent windows will start at 1 again
    lDocumentCount = 0
    
    'Pick file to open
    cFile.VBGetOpenFileName SFile, , , , , True, "Settings (*.rnm)|*.rnm", , , "Open Settings File", , Me.hwnd
    If SFile = vbNullString Then Exit Sub
    
    tFile = Mid(SFile, InStrRev(SFile, "\") + 1, Len(SFile) - InStrRev(SFile, "\"))

    getprofilesettings (SFile)
    Me.Caption = "Renamer - " & tFile
    
    'mark as clean
    IsDirty = False
    
End Sub

'File Menu: New
Private Sub mnuFileNew_Click()
    'Create new blank Document
    LoadNewDoc
End Sub

'PopUp Menu: About Renamer
Private Sub mnuAbout_Click()
    'Display About Form
    Unload frmAbout
    frmAbout.Show 1
End Sub

'PopUp Menu: Open
Private Sub mnuOpen_Click()
    'Display main Window
    If Me.WindowState = vbMinimized Then
        Me.WindowState = vbNormal
        Me.Visible = True
    Else
        AppActivate Me.Caption
    End If
End Sub

'ReadSettings from existing .rnm file
Public Sub getprofilesettings(InFileName$)

On Error GoTo Error_Handler     'trap errors

    'If no file specified then open default.rnm
    If InFileName$ = "" Then
        lpFileName$ = App.Path
        If Right$(lpFileName$, 1) <> "\" Then lpFileName$ = lpFileName$ + "\"
        lpFileName$ = lpFileName$ + "default.rnm"
    Else
        lpFileName$ = InFileName$
    End If
    
    'unload all open child windows
    VisibleForms% = Forms.Count
    For x% = VisibleForms% To 2 Step -1
        Unload Forms(x% - 1)
    Next
    
    'Read in number of sessions
    lpAppName$ = "Renamer"
    lpKeyName$ = "NumSessions"
    nDefault% = 0
    NumSessions% = GetPrivateProfileInt(lpAppName$, lpKeyName$, nDefault%, lpFileName$)
    
    'Read in last window state (minimized, maximized, etc)
    lpKeyName$ = "WindowState"
    WindowSize% = GetPrivateProfileInt(lpAppName$, lpKeyName$, 0, lpFileName$)
    Me.WindowState = WindowSize%
    
    'If no windows were open then that's as much info as we need
    If NumSessions% = 0 Then
        LoadNewDoc
        Exit Sub
    End If
    
    'Extend array
    ReDim AutoActivateForms(NumSessions% + 1)
    
    'For each chile window
    For x% = 1 To NumSessions%
        LoadNewDoc                              'Open new blank window
        lpAppName$ = "Session" + Format$(x%)
         
        lpKeyName$ = "InputFile"                'Set Input file
        lpRetString$ = String$(202, Chr$(0))
        slen% = GetPrivateProfileString(lpAppName$, lpKeyName$, "", lpRetString$, 200, lpFileName$)
        Forms(x%).Text1.Text = Left$(lpRetString$, slen%)
        
        lpKeyName$ = "FileExtension"            'Set File Extension
        lpRetString$ = String$(202, Chr$(0))
        slen% = GetPrivateProfileString(lpAppName$, lpKeyName$, "", lpRetString$, 200, lpFileName$)
        Forms(x%).Text2.Text = Left$(lpRetString$, slen%)

        lpKeyName$ = "Preamble"                 'Set Preamble
        lpRetString$ = String$(202, Chr$(0))
        slen% = GetPrivateProfileString(lpAppName$, lpKeyName$, "", lpRetString$, 200, lpFileName$)
        Forms(x%).txtPreAmble.Text = Left$(lpRetString$, slen%)

        lpKeyName$ = "Hour"                     'Set Hour
        test% = GetPrivateProfileInt(lpAppName$, lpKeyName$, 0, lpFileName$)
        Forms(x%).cboHour.ListIndex = test%
        
        lpKeyName$ = "Min"                      'Set Minutes
        lpRetString$ = String$(202, Chr$(0))
        slen% = GetPrivateProfileString(lpAppName$, lpKeyName$, "Min", lpRetString$, 200, lpFileName$)
        Forms(x%).cboMin.Text = Left$(lpRetString$, slen%)
        
        lpKeyName$ = "AmPm"                     'Set AM/PM
        test% = GetPrivateProfileInt(lpAppName$, lpKeyName$, 0, lpFileName$)
        Forms(x%).cboAmPm.ListIndex = test%
        
        lpKeyName$ = "Frequency"                'Set Frequency
        test% = GetPrivateProfileInt(lpAppName$, lpKeyName$, 0, lpFileName$)
        Forms(x%).Combo1.ListIndex = test%
        
        lpKeyName$ = "AutoActivate"             'Was this session active?
        test% = GetPrivateProfileInt(lpAppName$, lpKeyName$, 0, lpFileName$)
        If test% = 1 Then                       'If so, then reactivate it
            AutoActivateForms(x%) = 1
        End If
    Next
    
Exit_Normal:
    Exit Sub

Error_Handler:
    'On error display message box, then exit this routine
    'MsgBox "Error loading Settings: " & Err.Number & " : " & Err.Description, vbCritical, "Renamer"
    'Update log
    updateLog ICO_ERR, " " & Now & " : Error loading Settings: " & Err.Number & " : " & Err.Description
    Resume Exit_Normal
End Sub
